#ifndef WIN32

#include "MeetingAccountSDKWrapMac.h"
#include "MeetingSiteStorager.h"
#include "../MeetingServiceObjectManager.h"
#include "../cmr/CMRControllerMgr.h"


namespace CSFUnified {
    
    
    MeetingAccountSDKWrap::MeetingAccountSDKWrap()
    {
        m_pValidation = NULL;
    }
    
    MeetingAccountSDKWrap::~MeetingAccountSDKWrap()
    {
        m_pValidation = NULL;
    }
    
    MeetingAccountSDKWrap * MeetingAccountSDKWrap::getInstance()
    {
        static MeetingAccountSDKWrap * s_wrap = new MeetingAccountSDKWrap();
        if (NULL == s_wrap)
        {
            s_wrap = new MeetingAccountSDKWrap();
        }
        
        return s_wrap;
    }
    
    void MeetingAccountSDKWrap::start()
    {
        m_pOperator = MeetingSDKWrap::getInstance()->getAccountOperator();
        m_pValidation = MeetingSDKWrap::getInstance()->getAccountValidation();
        if (NULL != m_pValidation)
        {
            m_pValidation->setValidationEvent(this);
        }
    }
    
    void MeetingAccountSDKWrap::stop()
    {
        if (NULL != m_pValidation)
        {
            m_pValidation->setValidationEvent(NULL);
            m_pValidation = NULL;
        }
    }
    
    void MeetingAccountSDKWrap::verifyAccountWithPassword(std::string siteUrl, std::string userName, csf::SecureString userPass)
    {
        if (NULL != m_pValidation)
        {
            csf::SecureStringReader userPassReader;
            userPass.getUnsecureString(userPassReader);
            m_pValidation->verifyAccount(siteUrl.c_str(), userName.c_str(), userPassReader.c_str(), false);
        }
    }
    
    void MeetingAccountSDKWrap::verifyAccountWithSessionTicket(std::string siteUrl, std::string userName, std::string sessionTicket)
    {
        if (NULL != m_pValidation)
        {
            m_pValidation->verifyAccount(siteUrl.c_str(), userName.c_str(), sessionTicket.c_str(), true);
        }
    }
    
    void MeetingAccountSDKWrap::deleteDefaultAccount()
    {
        if (NULL != m_pOperator)
        {
            m_pOperator->clearAccount();
        }
        
        CMRControllerMgr * pMgr = MeetingServiceObjectManager::getInstance().getCMRMgr();
        if (NULL != pMgr)
        {
            CMRProperty property;
            pMgr->onPMRPropertyChange(true, false, property);
        }
    }
    
    void MeetingAccountSDKWrap::checkSSOSite(std::string siteUrl)
    {
        if (NULL != m_pValidation)
        {
            m_pValidation->checkSiteSSOInfo(siteUrl.c_str());
        }
    }
    
    int MeetingAccountSDKWrap::isSSOSite(std::string siteUrl)
    {
        if (NULL != m_pValidation)
        {
			return m_pValidation->getSiteSSOInfo(siteUrl.c_str());
        }
        
        return 0;
    }
    
    void MeetingAccountSDKWrap::checkSSOSiteList(std::list<std::string> siteList)
    {
        if (NULL != m_pValidation)
        {
            std::string siteUrlList;
            std::list<std::string>::iterator it = siteList.begin();
            while (it != siteList.end())
            {
                siteUrlList += "<";
                siteUrlList += (*it);
                siteUrlList += ">";
                it++;
            }
            m_pValidation->checkSiteListSSOInfo(siteUrlList.c_str());
        }
    }
    
    void MeetingAccountSDKWrap::onCheckSiteSSOInfo(WBX_MEETING_ACCOUNT_ERROR errorCode, const PString url, CHECK_SITE_SSO_RESULT result)
    {
        if (e_mae_success == errorCode)
        {
            MeetingSiteStorager::getInstance()->onCheckSSOSite(result, url.c_str());
        }
        else
        {
            JABBER_MEETING_ACCOUNT_ERROR_CODE jabberErrorCode = convertErrorCode(errorCode);
            MeetingSiteStorager::getInstance()->onVerifyAccount(false, jabberErrorCode, 0, "", 0);
        }
    }
    
    void MeetingAccountSDKWrap::onCheckSiteListSSOInfo()
    {
        MeetingSiteStorager::getInstance()->onCheckSiteListSSOInfo();
    }
    
    void MeetingAccountSDKWrap::onVerifyAccount(WBX_MEETING_ACCOUNT_ERROR result, const WbxMeetingAccountProperty& accountProperty, const WbxMeetingSiteProperty& siteProperty)
    {
        if (e_mae_success != result)
        {
            JABBER_MEETING_ACCOUNT_ERROR_CODE errorCode = convertErrorCode(result);
            MeetingSiteStorager::getInstance()->onVerifyAccount(false, errorCode, 0, "", 0);
        }
        else
        {
            if (NULL != m_pOperator)
            {
                m_pOperator->resetAccount(accountProperty, siteProperty);
            }

            MeetingSiteStorager::getInstance()->onVerifyAccount(true, 0, siteProperty.siteType, accountProperty.userSessionTicket.c_str(), accountProperty.sessionTicketExpiredTimer);
            
            CMRControllerMgr * pMgr = MeetingServiceObjectManager::getInstance().getCMRMgr();
            if (NULL != pMgr)
            {
                CMRProperty property;
                property.isCMR = accountProperty.isEnableCET;
                property.isPMR = accountProperty.applyPMRForInstantMeeting;
                property.fixedSipUrl = accountProperty.sipURL.c_str();
                property.fixedHostPin = accountProperty.hostPIN.c_str();
                property.fixedJoinUrl = accountProperty.personalMeetingRoomURL.c_str();
                property.siteUrl = accountProperty.siteURL.c_str();
                property.siteName = accountProperty.siteName.c_str();
                property.fixedMeetingKey = accountProperty.accessCode.c_str();
                property.fixedAccessCode = accountProperty.accessCode.c_str();
                pMgr->onPMRPropertyChange(true, property.isCMR, property);
            }
        }
    }
    
    JABBER_MEETING_ACCOUNT_ERROR_CODE MeetingAccountSDKWrap::convertErrorCode(WBX_MEETING_ACCOUNT_ERROR errorCode)
    {
        JABBER_MEETING_ACCOUNT_ERROR_CODE jabberErrorCode = e_jmaec_error_account_not_found;
        switch (errorCode)
        {
            case e_mae_success:
                jabberErrorCode = e_jmaec_success;
                break;
            case e_mae_network_error:
                jabberErrorCode = e_jmaec_error_network;
                break;
            case e_mae_argument_invalid:
                jabberErrorCode = e_jmaec_error_account_login_failed;
                break;
            case e_mae_security_issue:
                break;
            case e_mae_context_notsupport:
                jabberErrorCode = e_jmaec_error_account_site_release_not_support;
                break;
            case e_mae_file_error:
                break;
            case e_mae_invalid_account:
                jabberErrorCode = e_jmaec_error_account_unavailable;
                break;
            case e_mae_invalid_site_address:
                jabberErrorCode = e_jmaec_error_site_url_Invalid;
                break;
            case e_mae_invalid_password:
                jabberErrorCode = e_jmaec_error_account_password_invalid;
                break;
            case e_mae_user_not_found:
                jabberErrorCode = e_jmaec_error_account_not_found;
                break;
            case e_mae_invalid_email:
                jabberErrorCode = e_jmaec_error_account_no_user;
                break;
            case e_mae_account_not_active:
                jabberErrorCode = e_jmaec_error_account_user_inactive;
                break;
            case e_mae_account_locked:
                jabberErrorCode = e_jmaec_error_account_locked;
                break;
            case e_mae_password_expired:
                jabberErrorCode = e_jmaec_error_account_password_has_expired;
                break;
            case e_mae_less_than_4chars:
                jabberErrorCode = e_jmaec_error_account_password_force_change;
                break;
            case e_mae_site_maintenance:
                jabberErrorCode = e_jmaec_error_site_maintenance;
                break;
            case e_mae_action_not_found:
            case e_mae_site_url_not_found:
                jabberErrorCode = e_jmaec_error_account_site_url_not_found;
                break;
            case e_mea_attendee_only:
                jabberErrorCode = e_jmaec_error_donot_support_attendeerole;
                break;
            case e_mae_certification_verify_failed:
                jabberErrorCode = e_jmaec_error_certification_verify_failed;
                break;
            default:
                break;
                
        }
        
        return  jabberErrorCode;
    }
    
    
}

#endif